/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;

class ODNSDOutputMonitor
extends Thread {
    Process m_proc;
    MessageBundle s_gMsgBundle;

    public ODNSDOutputMonitor(Process proc, MessageBundle gMsgBundle) {
        this.m_proc = proc;
        this.s_gMsgBundle = gMsgBundle;
    }

    @Override
    public void run() {
        try {
            InputStreamReader opReader = new InputStreamReader(this.m_proc.getInputStream());
            BufferedReader br = new BufferedReader(opReader);
            String line = null;
            int lineCount = 0;
            Trace.out((String)"read output lines");
            while ((line = br.readLine()) != null) {
                Trace.out((String)line);
                switch (lineCount) {
                    case 0: {
                        if (line.indexOf("HEADER") != -1) {
                            lineCount = 1;
                            break;
                        }
                        Trace.out((String)("ignored - couldn't parse " + line));
                        break;
                    }
                    case 1: {
                        if (line.indexOf("QUERY: 1") != -1) {
                            lineCount = 2;
                            break;
                        }
                        lineCount = 0;
                        Trace.out((String)("Ignored - couldn't parse" + line));
                        break;
                    }
                    case 2: {
                        int commaIndex = line.indexOf(",");
                        if (commaIndex < 2) {
                            Trace.out((String)("Ignored - couldn't parse" + line));
                            lineCount = 0;
                            break;
                        }
                        String lookupName = line.substring(2, commaIndex).trim();
                        if (lookupName != null || lookupName.length() != 0) {
                            ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("5801", false, (Object[])new String[]{lookupName}));
                        } else {
                            Trace.out((String)"lookup name is empty");
                        }
                        lineCount = 0;
                    }
                }
            }
        }
        catch (IOException e) {
            Trace.out((String)("IOE while reading odnsd output : " + e.getMessage()));
        }
    }
}

